<?php
require_once 'config.php';

// Debug P12 file validation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['p12_file'])) {
    $file = $_FILES['p12_file'];
    
    echo "<h3>P12 File Debug Info:</h3>";
    echo "Name: " . htmlspecialchars($file['name']) . "<br>";
    echo "Type: " . htmlspecialchars($file['type']) . "<br>";
    echo "Size: " . $file['size'] . " bytes<br>";
    echo "Error: " . $file['error'] . "<br>";
    
    if ($file['error'] === UPLOAD_ERR_OK) {
        $tempPath = $file['tmp_name'];
        
        // Read first few bytes
        $content = file_get_contents($tempPath, false, null, 0, 20);
        echo "First 20 bytes (hex): " . bin2hex($content) . "<br>";
        echo "First 20 bytes (readable): " . htmlspecialchars($content) . "<br>";
        
        // Try OpenSSL test
        $output = [];
        $returnCode = 0;
        exec("openssl pkcs12 -in \"$tempPath\" -passin pass: -noout 2>&1", $output, $returnCode);
        echo "OpenSSL test return code: $returnCode<br>";
        echo "OpenSSL output: " . htmlspecialchars(implode("\n", $output)) . "<br>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>P12 Debug Test</title>
</head>
<body>
    <h2>Upload P12 File for Debug</h2>
    <form method="post" enctype="multipart/form-data">
        <input type="file" name="p12_file" accept=".p12" required>
        <button type="submit">Test P12</button>
    </form>
</body>
</html>
