<?php
// Check PHP OpenSSL extension
echo "<h2>PHP OpenSSL Extension Check</h2>";

if (extension_loaded('openssl')) {
    echo "✅ OpenSSL extension is loaded<br>";
    
    // Test basic OpenSSL functions
    echo "<h3>OpenSSL Functions Available:</h3>";
    
    $functions = [
        'openssl_pkcs12_read',
        'openssl_x509_parse',
        'openssl_pkey_get_private',
        'openssl_pkey_get_public'
    ];
    
    foreach ($functions as $func) {
        if (function_exists($func)) {
            echo "✅ $func<br>";
        } else {
            echo "❌ $func<br>";
        }
    }
    
    // Test P12 file if uploaded
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['p12_file'])) {
        echo "<h3>P12 File Test:</h3>";
        $file = $_FILES['p12_file'];
        
        if ($file['error'] === UPLOAD_ERR_OK) {
            $p12Content = file_get_contents($file['tmp_name']);
            $password = $_POST['password'] ?? '';
            
            echo "File size: " . strlen($p12Content) . " bytes<br>";
            
            $certs = [];
            if (openssl_pkcs12_read($p12Content, $certs, $password)) {
                echo "✅ P12 parsing successful with password<br>";
                echo "Contains cert: " . (isset($certs['cert']) ? 'Yes' : 'No') . "<br>";
                echo "Contains pkey: " . (isset($certs['pkey']) ? 'Yes' : 'No') . "<br>";
                
                if (isset($certs['cert'])) {
                    $cert = openssl_x509_parse($certs['cert']);
                    if ($cert) {
                        echo "Certificate subject: " . print_r($cert['subject'], true) . "<br>";
                    }
                }
            } else {
                echo "❌ P12 parsing failed with provided password<br>";
                
                // Try empty password
                if (openssl_pkcs12_read($p12Content, $certs, '')) {
                    echo "✅ P12 parsing successful with empty password<br>";
                } else {
                    echo "❌ P12 parsing failed with empty password too<br>";
                    echo "OpenSSL errors: " . openssl_error_string() . "<br>";
                }
            }
        }
    }
    
} else {
    echo "❌ OpenSSL extension is NOT loaded<br>";
}

echo "<h3>PHP Info:</h3>";
echo "PHP Version: " . PHP_VERSION . "<br>";
echo "Extensions: " . implode(', ', get_loaded_extensions()) . "<br>";
?>

<form method="post" enctype="multipart/form-data">
    <h3>Test P12 File:</h3>
    <input type="file" name="p12_file" accept=".p12" required><br>
    <input type="password" name="password" placeholder="P12 Password"><br>
    <button type="submit">Test P12</button>
</form>
