<?php
require_once 'config.php';
require_once 'classes/OCSPValidator.php';

/**
 * Test script để kiểm tra OCSP validation
 * Usage: php test_ocsp.php [path_to_p12] [password]
 */

if (php_sapi_name() !== 'cli') {
    die('Script này chỉ chạy được từ command line');
}

if ($argc < 3) {
    echo "Usage: php test_ocsp.php [path_to_p12] [password]\n";
    echo "Example: php test_ocsp.php /path/to/cert.p12 'password123'\n";
    exit(1);
}

$p12Path = $argv[1];
$password = $argv[2];

if (!file_exists($p12Path)) {
    echo "File P12 không tồn tại: $p12Path\n";
    exit(1);
}

echo "Đang kiểm tra OCSP cho certificate: $p12Path\n";
echo "Đang kết nối đến Apple OCSP servers...\n\n";

try {
    $validator = new OCSPValidator();
    $result = $validator->validateCertificate($p12Path, $password);
    
    echo "=== KẾT QUẢ OCSP VALIDATION ===\n";
    echo "Success: " . ($result['success'] ? 'YES' : 'NO') . "\n";
    echo "Message: " . $result['message'] . "\n";
    echo "Is Revoked: " . ($result['is_revoked'] ? 'YES' : 'NO') . "\n";
    
    if (isset($result['revoke_time'])) {
        echo "Revocation Time: " . $result['revoke_time'] . "\n";
    }
    
    if (isset($result['status_unknown'])) {
        echo "Status Unknown: " . ($result['status_unknown'] ? 'YES' : 'NO') . "\n";
    }
    
    echo "\n=== RAW OCSP RESPONSE ===\n";
    if (isset($result['raw_response'])) {
        echo $result['raw_response'] . "\n";
    }
    
    // Test certificate expiration
    echo "\n=== CERTIFICATE EXPIRATION ===\n";
    $expResult = $validator->validateCertificateExpiration($p12Path, $password);
    
    if ($expResult['success']) {
        echo "Valid From: " . $expResult['valid_from'] . "\n";
        echo "Valid To: " . $expResult['valid_to'] . "\n";
        echo "Days Until Expiry: " . $expResult['days_until_expiry'] . "\n";
        echo "Expires Soon: " . ($expResult['expires_soon'] ? 'YES' : 'NO') . "\n";
    } else {
        echo "Expiration Check Failed: " . $expResult['message'] . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\nTest completed!\n";
?>
