<?php
require_once 'config.php';

// Get signed file parameter
$signedFile = isset($_GET['file']) ? basename($_GET['file']) : '';

if (empty($signedFile)) {
    header('Location: index.php');
    exit;
}

$filePath = DOWNLOADS_DIR . $signedFile;

if (!file_exists($filePath)) {
    header('Location: index.php');
    exit;
}

// Generate install URL for iOS
$installUrl = 'itms-services://?action=download-manifest&url=' . urlencode(SITE_URL . '/manifest.php?file=' . urlencode($signedFile));

// Generate QR code URL
$qrCodeUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=' . urlencode($installUrl);
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ký số thành công - iPa Signer</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Ctext y='.9em' font-size='90'%3E📱%3C/text%3E%3C/svg%3E">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-mobile-alt me-2"></i>
                iPa Signer
            </a>
            <div class="ms-auto">
                <button class="btn btn-outline-light btn-sm" id="themeToggle">
                    <i class="fas fa-moon" id="themeIcon"></i>
                </button>
            </div>
        </div>
    </nav>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card main-card">
                    <div class="card-body success-container">
                        <div class="success-icon">
                            <i class="fas fa-check"></i>
                        </div>
                        
                        <h1 class="h2 mb-3 text-success">Ký số thành công!</h1>
                        <p class="text-muted mb-4">File IPA của bạn đã được ký số thành công và sẵn sàng để cài đặt.</p>
                        
                        <div class="download-info">
                            <h5><i class="fas fa-file-archive me-2"></i>Thông tin file</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Tên file:</strong> <?php echo htmlspecialchars($signedFile); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Kích thước:</strong> <?php echo number_format(filesize($filePath) / (1024 * 1024), 2); ?> MB</p>
                                </div>
                            </div>
                        </div>

                        <div class="qr-container">
                            <h5 class="mb-3"><i class="fas fa-qrcode me-2"></i>Quét QR để cài đặt trên iOS</h5>
                            <img src="<?php echo $qrCodeUrl; ?>" alt="QR Code" class="img-fluid mb-3" style="max-width: 250px;">
                            <p class="text-muted small">Quét mã QR này bằng camera iPhone/iPad để cài đặt ứng dụng</p>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6 mb-3">
                                <a href="<?php echo 'downloads/' . $signedFile; ?>" class="btn btn-primary btn-lg w-100" download>
                                    <i class="fas fa-download me-2"></i>
                                    Tải xuống IPA
                                </a>
                            </div>
                            <div class="col-md-6 mb-3">
                                <button class="btn btn-success btn-lg w-100" onclick="openInstallUrl()">
                                    <i class="fas fa-mobile-alt me-2"></i>
                                    Cài đặt trên iOS
                                </button>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6 mb-3">
                                <button class="btn btn-outline-primary w-100" onclick="copyInstallUrl()">
                                    <i class="fas fa-copy me-2"></i>
                                    Copy link cài đặt
                                </button>
                            </div>
                            <div class="col-md-6 mb-3">
                                <button class="btn btn-outline-secondary w-100" onclick="shareFile()">
                                    <i class="fas fa-share-alt me-2"></i>
                                    Chia sẻ
                                </button>
                            </div>
                        </div>

                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>Hướng dẫn cài đặt:</h6>
                            <ol class="mb-0 text-start">
                                <li>Trên iPhone/iPad, mở Settings → General → VPN & Device Management</li>
                                <li>Tìm và tin cậy Developer App từ chứng chỉ của bạn</li>
                                <li>Quay lại Home screen và mở ứng dụng</li>
                            </ol>
                        </div>

                        <div class="alert alert-warning">
                            <h6><i class="fas fa-clock me-2"></i>Lưu ý quan trọng:</h6>
                            <p class="mb-0">File sẽ được tự động xóa sau <strong>30 phút</strong> để bảo vệ quyền riêng tư. Vui lòng tải xuống ngay.</p>
                        </div>

                        <div class="text-center">
                            <a href="index.php" class="btn btn-outline-primary">
                                <i class="fas fa-arrow-left me-2"></i>
                                Ký file khác
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer mt-5">
        <div class="container text-center">
            <p class="mb-0">&copy; 2025 iPa Signer. Được tạo với <i class="fas fa-heart text-danger"></i></p>
        </div>
    </footer>

    <!-- Toast for notifications -->
    <div class="toast-container position-fixed top-0 end-0 p-3">
        <div id="successToast" class="toast" role="alert">
            <div class="toast-header">
                <i class="fas fa-check-circle text-success me-2"></i>
                <strong class="me-auto">Thành công</strong>
                <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body" id="toastMessage">
                Đã copy link cài đặt vào clipboard!
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Theme management
        class ThemeManager {
            constructor() {
                this.init();
            }

            init() {
                const savedTheme = localStorage.getItem('theme') || 'light';
                this.setTheme(savedTheme);
                this.bindEvents();
            }

            setTheme(theme) {
                document.body.classList.toggle('dark-mode', theme === 'dark');
                const themeIcon = document.getElementById('themeIcon');
                if (themeIcon) {
                    themeIcon.className = theme === 'dark' ? 'fas fa-sun' : 'fas fa-moon';
                }
                localStorage.setItem('theme', theme);
            }

            toggleTheme() {
                const isDark = document.body.classList.contains('dark-mode');
                this.setTheme(isDark ? 'light' : 'dark');
            }

            bindEvents() {
                const themeToggle = document.getElementById('themeToggle');
                if (themeToggle) {
                    themeToggle.addEventListener('click', () => this.toggleTheme());
                }
            }
        }

        // Install URL
        const installUrl = '<?php echo $installUrl; ?>';

        function openInstallUrl() {
            window.location.href = installUrl;
        }

        function copyInstallUrl() {
            navigator.clipboard.writeText(installUrl).then(() => {
                showToast('Đã copy link cài đặt vào clipboard!');
            }).catch(() => {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = installUrl;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                showToast('Đã copy link cài đặt vào clipboard!');
            });
        }

        function shareFile() {
            if (navigator.share) {
                navigator.share({
                    title: 'iPa Signer - Ứng dụng đã ký',
                    text: 'Cài đặt ứng dụng iOS đã được ký số',
                    url: installUrl
                });
            } else {
                copyInstallUrl();
            }
        }

        function showToast(message) {
            const toastEl = document.getElementById('successToast');
            const toastMessage = document.getElementById('toastMessage');
            toastMessage.textContent = message;
            
            const toast = new bootstrap.Toast(toastEl);
            toast.show();
        }

        // Initialize
        document.addEventListener('DOMContentLoaded', () => {
            new ThemeManager();
            
            // Add animation to success elements
            const successIcon = document.querySelector('.success-icon');
            if (successIcon) {
                successIcon.classList.add('fade-in');
            }
            
            const qrContainer = document.querySelector('.qr-container');
            if (qrContainer) {
                setTimeout(() => {
                    qrContainer.classList.add('slide-up');
                }, 500);
            }
        });

        // Auto-refresh countdown (optional)
        let timeLeft = 30 * 60; // 30 minutes in seconds
        
        function updateCountdown() {
            const hours = Math.floor(timeLeft / 3600);
            const minutes = Math.floor((timeLeft % 3600) / 60);
            const seconds = timeLeft % 60;
            
            const countdownText = `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
            
            // You can uncomment this to show countdown
            // console.log('File will be deleted in:', countdownText);
            
            if (timeLeft <= 0) {
                location.reload(); // Refresh page when time is up
            }
            
            timeLeft--;
        }
        
        // Update countdown every second
        setInterval(updateCountdown, 1000);
    </script>
</body>
</html>
