<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>iPa Signer - Ký số ứng dụng iOS</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'%3E%3Ctext y='.9em' font-size='90'%3E📱%3C/text%3E%3C/svg%3E">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-mobile-alt me-2"></i>
                iPa Signer
            </a>
            <div class="ms-auto">
                <button class="btn btn-outline-light btn-sm" id="themeToggle">
                    <i class="fas fa-moon" id="themeIcon"></i>
                </button>
            </div>
        </div>
    </nav>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card main-card">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <div class="icon-container mb-3">
                                <i class="fas fa-signature"></i>
                            </div>
                            <h1 class="h2 mb-3">Ký số ứng dụng iOS</h1>
                            <p class="text-muted">Ký file IPA với chứng chỉ Apple Developer của bạn một cách an toàn và nhanh chóng</p>
                        </div>

                        <form id="signForm" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="upload-area" id="ipaUpload">
                                        <i class="fas fa-file-archive mb-3"></i>
                                        <h5>File IPA</h5>
                                        <p class="text-muted">Kéo thả hoặc click để chọn file IPA (tối đa 100MB)</p>
                                        <input type="file" id="ipaFile" name="ipa_file" accept=".ipa" class="d-none">
                                        <div class="file-info d-none">
                                            <i class="fas fa-check-circle text-success"></i>
                                            <span class="file-name"></span>
                                            <small class="file-size text-muted"></small>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-4">
                                    <div class="upload-area" id="p12Upload">
                                        <i class="fas fa-certificate mb-3"></i>
                                        <h5>Chứng chỉ P12</h5>
                                        <p class="text-muted">File chứng chỉ Apple Developer (.p12)</p>
                                        <input type="file" id="p12File" name="p12_file" accept=".p12" class="d-none">
                                        <div class="file-info d-none">
                                            <i class="fas fa-check-circle text-success"></i>
                                            <span class="file-name"></span>
                                            <small class="file-size text-muted"></small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <div class="upload-area" id="mobileprovisionUpload">
                                        <i class="fas fa-id-card mb-3"></i>
                                        <h5>Provisioning Profile</h5>
                                        <p class="text-muted">File .mobileprovision</p>
                                        <input type="file" id="mobileprovisionFile" name="mobileprovision_file" accept=".mobileprovision" class="d-none">
                                        <div class="file-info d-none">
                                            <i class="fas fa-check-circle text-success"></i>
                                            <span class="file-name"></span>
                                            <small class="file-size text-muted"></small>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-4">
                                    <label for="p12Password" class="form-label">
                                        <i class="fas fa-lock me-2"></i>Mật khẩu P12
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="p12Password" name="p12_password" placeholder="Nhập mật khẩu chứng chỉ">
                                        <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-lg px-5" id="signBtn">
                                    <i class="fas fa-signature me-2"></i>
                                    Bắt đầu ký số
                                </button>
                            </div>
                        </form>

                        <div class="progress-container d-none" id="progressContainer">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span id="progressText">Đang chuẩn bị...</span>
                                <span id="progressPercent">0%</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar" id="progressBar" role="progressbar" style="width: 0%"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-4">
                        <div class="feature-card">
                            <i class="fas fa-shield-alt"></i>
                            <h5>Bảo mật cao</h5>
                            <p>Kiểm tra OCSP để đảm bảo chứng chỉ không bị thu hồi</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="feature-card">
                            <i class="fas fa-rocket"></i>
                            <h5>Tốc độ nhanh</h5>
                            <p>Xử lý ký số với công nghệ tối ưu hiệu năng cao</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="feature-card">
                            <i class="fas fa-trash-alt"></i>
                            <h5>Tự động dọn dẹp</h5>
                            <p>Files được xóa tự động sau 30 phút để bảo vệ dữ liệu</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer mt-5">
        <div class="container text-center">
            <p class="mb-0">&copy; 2025 iPa Signer. Được tạo với <i class="fas fa-heart text-danger"></i></p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>        <script src="assets/js/script_enhanced.js"></script>
        
        <!-- Connection Indicator -->
        <div class="connection-indicator" title="Trạng thái kết nối"></div>
        
        <!-- Performance Analytics (if needed) -->
        <?php if (defined('ANALYTICS_ENABLED') && ANALYTICS_ENABLED): ?>
        <script>
            // Add analytics code here if needed
            console.log('Analytics enabled for production');
        </script>
        <?php endif; ?>
    </body>
</html>
