<?php
require_once 'config.php';

// Enhanced security token handler
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Security headers
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');

// Log token request
logAccess('token_request');

try {
    // Generate security token if rate limiting allows
    if (!checkRateLimit()) {
        http_response_code(429);
        echo json_encode([
            'success' => false,
            'message' => 'Quá nhiều request. Vui lòng thử lại sau.'
        ]);
        exit;
    }

    $token = generateSecurityToken();
    
    if ($token) {
        logAccess('token_generated');
        echo json_encode([
            'success' => true,
            'token' => $token,
            'expires_in' => 3600 // 1 hour
        ]);
    } else {
        logAccess('token_generation_failed');
        echo json_encode([
            'success' => false,
            'message' => 'Không thể tạo token bảo mật'
        ]);
    }

} catch (Exception $e) {
    logAccess('token_error', $e->getMessage());
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Lỗi server khi tạo token'
    ]);
}
?>
