# iPa Signer - Standalone

Ứng dụng web ký số file IPA với chứng chỉ Apple Developer. Tích hợp hoàn toàn logic OCSP validation và IPA signing mà không cần dependencies external.

## Tính năng

### 🔐 Bảo mật
- **Xác thực OCSP tích hợp**: Kiểm tra chứng chỉ bị thu hồi (từ apple-cert-ocsp-verification)
- **Enhanced detection**: Multi-pattern detection cho accuracy cao
- **Validation đầy đủ**: Kiểm tra file format, size, và tính hợp lệ
- **Tự động cleanup**: Xóa files sau 30 phút để bảo vệ dữ liệu
- **Security headers**: Bảo vệ chống các attack phổ biến

### 📱 Giao diện
- **Responsive design**: Tối ưu cho mọi thiết bị
- **Dark/Light mode**: Chuyển đổi theme dễ dàng
- **Modern UI**: Giao diện đẹp, hiện đại với animations
- **Drag & Drop**: Upload file bằng kéo thả

### ⚡ Hiệu năng
- **Standalone**: Không cần Node.js hay external dependencies
- **File size limit**: Hỗ trợ IPA tối đa 100MB
- **Progress tracking**: Hiển thị tiến trình xử lý realtime
- **Error handling**: Xử lý lỗi chi tiết và thông báo rõ ràng

### 📲 Cài đặt
- **QR Code**: Tạo QR code tự động cho cài đặt iOS
- **OTA Installation**: Hỗ trợ cài đặt Over-The-Air
- **Manifest generation**: Tự động tạo manifest.plist

## Cài đặt

### Yêu cầu hệ thống
- PHP 7.4+ với OpenSSL extension
- Apache/Nginx với mod_rewrite
- OpenSSL command line tools
- zsign binary (tùy chọn, xem hướng dẫn trong `tools/INSTALL_ZSIGN.md`)

### Các bước cài đặt

1. **Setup thư mục**
```bash
# Đảm bảo các thư mục có quyền ghi
chmod 755 uploads/ temp/ downloads/ logs/ certificates/
chmod 644 config.php
```

2. **Kiểm tra Apple WWDR CA certificate**
   - File `certificates/AppleWWDRCAG3.pem` đã có sẵn
   - Không cần copy từ thư mục khác

3. **Cấu hình web server**
   - Đảm bảo `.htaccess` được load (Apache)
   - Hoặc cấu hình tương tự cho Nginx

4. **Cài đặt zsign (tùy chọn)**
   - Xem hướng dẫn chi tiết trong `tools/INSTALL_ZSIGN.md`
   - Không bắt buộc nhưng tối ưu hiệu năng

## Sử dụng

### Upload và ký file
1. Truy cập website
2. Upload file IPA (tối đa 100MB)
3. Upload chứng chỉ P12
4. Upload Provisioning Profile (.mobileprovision)
5. Nhập mật khẩu P12
6. Click "Bắt đầu ký số"

### Cài đặt trên iOS
1. Sau khi ký thành công, quét QR code bằng camera iOS
2. Hoặc click "Cài đặt trên iOS" để mở itms-services link
3. Tin cậy Developer trong Settings > General > VPN & Device Management

## Cấu trúc dự án

```
ipaSign/ (Standalone)
├── index.php              # Trang upload chính
├── process.php             # Xử lý ký file
├── success.php             # Trang thành công + QR
├── manifest.php            # iOS manifest
├── cleanup.php             # Auto cleanup
├── config.php              # Cấu hình
├── assets/
│   ├── css/style.css      # Styles hiện đại
│   ├── js/script.js       # JavaScript logic
│   └── images/            # Icons và assets
├── classes/
│   ├── FileManager.php    # Upload & validation
│   ├── OCSPValidator.php  # OCSP checking (tích hợp)
│   └── IPASigner.php      # IPA signing logic (tích hợp)
├── certificates/
│   └── AppleWWDRCAG3.pem  # Apple CA certificate
├── tools/
│   ├── INSTALL_ZSIGN.md   # Hướng dẫn cài zsign
│   └── [zsign binary]     # (optional)
└── [uploads, temp, downloads, logs]/
```

## API Documentation

### POST /process.php
Xử lý upload và ký file IPA.

**Parameters:**
- `ipa_file`: File IPA (multipart/form-data)
- `p12_file`: File chứng chỉ P12 (multipart/form-data)  
- `mobileprovision_file`: File .mobileprovision (multipart/form-data)
- `p12_password`: Mật khẩu P12 (string)

**Response:**
```json
{
  "success": true,
  "message": "Ký IPA thành công",
  "signed_file": "app_signed_2025-01-13_10-30-45.ipa",
  "download_url": "downloads/app_signed_2025-01-13_10-30-45.ipa",
  "install_url": "itms-services://..."
}
```

### GET /manifest.php?file={filename}
Tạo manifest.plist cho cài đặt OTA.

**Parameters:**
- `file`: Tên file IPA đã ký

**Response:** XML manifest plist

## Bảo mật

### File Upload Security
- Kiểm tra file extension và MIME type
- Giới hạn kích thước file
- Validation nội dung file
- Ngăn chặn file thực thi

### OCSP Validation
- Kiểm tra chứng chỉ có bị thu hồi
- Validation với Apple WWDR CA
- Error handling chi tiết

### Auto Cleanup
- Xóa files sau 30 phút
- Cleanup tự động theo schedule
- Log cleanup activities

## Maintenance

### Cleanup thủ công
```bash
php cleanup.php
```

### Cron job (Linux)
```bash
# Chạy cleanup mỗi 15 phút
*/15 * * * * /usr/bin/php /path/to/ipaSign/cleanup.php
```

### Task Scheduler (Windows)
Tạo task chạy `php cleanup.php` mỗi 15 phút.

## Troubleshooting

### Lỗi upload file
- Kiểm tra permissions thư mục
- Kiểm tra `upload_max_filesize` trong PHP
- Kiểm tra disk space

### Lỗi OCSP validation
- Kiểm tra kết nối internet
- Kiểm tra Apple WWDR CA certificate
- Kiểm tra OpenSSL installation

### Lỗi signing
- Kiểm tra zsign binary
- Kiểm tra mật khẩu P12
- Kiểm tra compatibility của cert và mobileprovision

## License

MIT License - Xem file LICENSE để biết thêm chi tiết.

## Support

Nếu gặp vấn đề, vui lòng:
1. Kiểm tra logs trong thư mục `logs/`
2. Đảm bảo đáp ứng đầy đủ system requirements
3. Tạo issue với thông tin chi tiết lỗi
