# 🚀 Hướng dẫn Deploy iPa Signer lên cPanel Hosting - Production Ready

## 📋 Tổng quan
Phiên bản này đã được nâng cấp với các tính năng production-ready:
- ✅ Auto-detection domain và environment
- ✅ Security hardening với rate limiting  
- ✅ Enhanced error handling và logging
- ✅ Progressive Web App với Service Worker
- ✅ Offline support và connection monitoring
- ✅ Advanced file validation và progress tracking
- ✅ Enhanced UI/UX với dark mode support
- ✅ Automatic cleanup system

## 🎯 Yêu cầu Hosting

### Minimum Requirements:
- **PHP**: 7.4+ (Recommended: 8.0+)
- **Extensions**: OpenSSL, ZIP, JSON, cURL
- **Memory**: 256MB+ (512MB recommended)
- **Disk**: 2GB+ free space
- **Upload**: 500MB+ max file size

### cPanel Features:
- File Manager access
- Database support (optional)
- Cron Jobs (for cleanup)
- SSL Certificate (recommended)

## 📦 Deployment Steps

### Bước 1: Chuẩn bị file deploy
```bash
# Chạy script tạo package
create_deploy_package.bat
```
Package sẽ được tạo trong folder `deploy/`

### Bước 2: Upload lên cPanel

1. **Login vào cPanel** → File Manager
2. **Navigate** đến `public_html` (hoặc subdomain folder)
3. **Upload** file `ipasigner-deploy.zip`
4. **Extract** package trong cPanel File Manager
5. **Set permissions** cho các folder:
   ```
   uploads/     755
   downloads/   755
   temp/        755
   logs/        755
   ```

### Bước 3: Cấu hình tự động

1. **Truy cập website** qua browser: `https://yourdomain.com`
2. **Check status**: `https://yourdomain.com/status.php`
3. System sẽ **tự động detect** và configure:
   - Domain và SSL settings
   - PHP environment và extensions
   - Directory permissions
   - Security settings

### Bước 4: Verify Installation

**Green indicators nghĩa là OK:**
- ✅ PHP Version
- ✅ Required Extensions
- ✅ Directory Permissions
- ✅ File Upload Limits
- ✅ Security Settings

## ⚙️ Advanced Configuration

### Environment Variables (tùy chọn)
Tạo file `.env` trong root directory:
```env
# Production settings
ENVIRONMENT=production
DEBUG_MODE=false
MAX_FILE_SIZE=500MB
RATE_LIMIT_ENABLED=true
CLEANUP_ENABLED=true
CLEANUP_INTERVAL=24
LOG_LEVEL=error
```

### Cron Jobs Setup (khuyến nghị)
Trong cPanel → Cron Jobs, add:
```bash
# Cleanup old files mỗi ngày lúc 2:00 AM
0 2 * * * /usr/bin/php /path/to/your/site/cleanup.php
```

### SSL Configuration
1. **Enable SSL** trong cPanel
2. **Force HTTPS** redirect (đã có trong .htaccess)
3. **Update SITE_URL** nếu cần thiết

## 🔧 Troubleshooting

### Lỗi thường gặp:

#### 1. PHP Extensions thiếu
```bash
# Contact hosting provider to enable:
- php-openssl
- php-zip  
- php-json
- php-curl
```

#### 2. Permission denied
```bash
# Set correct permissions:
chmod 755 uploads/ downloads/ temp/ logs/
chmod 644 *.php
```

#### 3. File upload size limit
```
# Check và edit .htaccess:
php_value upload_max_filesize 500M
php_value post_max_size 500M
php_value max_execution_time 300
```

#### 4. Memory limit issues
```
# Contact hosting để tăng memory_limit >= 256M
# Hoặc upgrade hosting plan
```

### Debug Mode
Nếu cần debug, edit `config.php`:
```php
define('DEBUG_MODE', true);
define('IS_PRODUCTION', false);
```

## 🎨 Customization

### Theme Colors
Edit `assets/css/style.css` → `:root` section:
```css
:root {
    --primary-color: #your-color;
    --secondary-color: #your-color;
}
```

### App Info
Edit `config.php`:
```php
define('APP_NAME', 'Your App Name');
define('APP_VERSION', '2.0.0');
```

### Rate Limiting
Adjust trong `config.php`:
```php
define('RATE_LIMIT_REQUESTS', 10);
define('RATE_LIMIT_WINDOW', 3600);
```

## 📊 Monitoring

### Log Files
- `logs/access.log` - User activity
- `logs/error.log` - PHP errors  
- `logs/cleanup.log` - Cleanup activity
- `logs/last_cleanup.txt` - Last cleanup time

### Performance Check
- Monitor `status.php` for system health
- Check disk usage regularly
- Monitor error logs

### Analytics
Optional: Add Google Analytics hoặc similar:
```php
// Trong config.php
define('ANALYTICS_ENABLED', true);
```

## 🔐 Security Best Practices

### Already Implemented:
- ✅ File type validation
- ✅ Rate limiting
- ✅ Security headers
- ✅ Input sanitization
- ✅ Directory protection
- ✅ Token-based security

### Additional Recommendations:
1. **Regular backups** của website
2. **Monitor logs** thường xuyên
3. **Update PHP** version when possible
4. **Use strong passwords** cho cPanel
5. **Enable 2FA** cho hosting account

## 🚀 Performance Optimization

### Implemented Features:
- ✅ Service Worker caching
- ✅ Progressive Web App
- ✅ Gzip compression  
- ✅ Browser caching
- ✅ Offline support
- ✅ Connection monitoring

### Additional Optimizations:
1. **CDN** (CloudFlare recommended)
2. **Image optimization**
3. **Database optimization** (nếu dùng)
4. **PHP OpCache** enable

## 📱 Mobile Support

### PWA Features:
- ✅ Install prompt on mobile
- ✅ Offline functionality
- ✅ Background sync
- ✅ Push notifications ready
- ✅ Responsive design

### iOS Installation:
1. Open website in Safari
2. Tap "Share" button
3. Select "Add to Home Screen"
4. App sẽ hoạt động như native app

## 🎯 Production Checklist

### Pre-Launch:
- [ ] SSL certificate installed
- [ ] All status checks green
- [ ] Test file upload/signing
- [ ] Test download/install on iOS
- [ ] Verify cleanup system
- [ ] Check error logging

### Post-Launch:
- [ ] Monitor error logs daily
- [ ] Check disk usage weekly  
- [ ] Test functionality monthly
- [ ] Update dependencies quarterly
- [ ] Backup system regular

## 📞 Support

### Hosting Issues:
1. Check `status.php` first
2. Review error logs
3. Contact hosting provider với specific error messages

### Code Issues:
1. Enable debug mode temporarily
2. Check browser console errors
3. Review `logs/error.log`

### Performance Issues:
1. Check `status.php` performance tab
2. Monitor hosting resource usage
3. Consider hosting upgrade

---

## 🎉 Deployment hoàn tất!

Website của bạn giờ đây đã ready cho production với:
- 🔒 **Security**: Rate limiting, input validation, secure headers
- 📱 **Mobile**: PWA support, offline functionality  
- 🚀 **Performance**: Caching, compression, optimization
- 🔧 **Maintenance**: Auto-cleanup, logging, monitoring
- 🎨 **UX**: Modern UI, dark mode, progress tracking

**URL:** `https://yourdomain.com`
**Status:** `https://yourdomain.com/status.php`

Happy signing! 🎊
