# iPa Signer - Deployment Guide for cPanel/Shared Hosting

## Pre-deployment Checklist

### 1. Hosting Requirements
- PHP 7.4+ (8.0+ recommended)
- OpenSSL extension enabled
- ZIP extension enabled  
- File upload limit: 50MB+
- Memory limit: 256MB+
- Execution time: 5 minutes+

### 2. File Upload Instructions

#### Via cPanel File Manager:
1. Login to your cPanel
2. Open File Manager
3. Navigate to `public_html` (or your domain's root folder)
4. Upload all project files to your domain folder
5. Extract if uploaded as ZIP

#### Via FTP:
1. Connect to your hosting via FTP client
2. Upload all files to `public_html` or domain root
3. Ensure file permissions are set correctly

### 3. File Permissions Setup

Set the following permissions after upload:

```bash
# Directories (755)
uploads/          - 755
temp/            - 755  
downloads/       - 755
logs/            - 755
certificates/    - 755

# PHP files (644)
*.php            - 644
*.css            - 644
*.js             - 644

# Config files (600) - more secure
config.php       - 600
.htaccess        - 644
```

### 4. Directory Structure Verification

After upload, your hosting should have:
```
public_html/
├── index.php
├── process.php
├── success.php
├── manifest.php
├── config.php
├── .htaccess
├── assets/
│   ├── css/
│   └── js/
├── classes/
│   ├── FileManager.php
│   ├── IPASigner.php
│   └── OCSPValidator.php
├── uploads/
│   ├── ipa/
│   ├── p12/
│   └── mobileprovision/
├── temp/
├── downloads/
├── logs/
└── certificates/
    └── AppleWWDRCAG3.pem
```

### 5. Post-Deployment Testing

1. **Access Status Page:**
   ```
   https://yourdomain.com/status.php
   ```
   Check for any compatibility issues.

2. **Test OpenSSL:**
   ```
   https://yourdomain.com/test_openssl.php
   ```
   Upload a P12 file to verify parsing works.

3. **Test Main Function:**
   ```
   https://yourdomain.com/
   ```
   Try uploading and signing an IPA file.

### 6. Common Hosting Issues & Solutions

#### Issue: Directory Permissions
**Error:** "Permission denied" or "Cannot create directory"
**Solution:**
```bash
# Set via cPanel File Manager or FTP
chmod 755 uploads/ temp/ downloads/ logs/
```

#### Issue: PHP Memory/Time Limits
**Error:** "Maximum execution time exceeded"
**Solution:** The `.htaccess` file should handle this, but if not:
- Contact hosting support to increase limits
- Or add to `.htaccess`:
```apache
php_value memory_limit 256M
php_value max_execution_time 300
```

#### Issue: OpenSSL Not Available
**Error:** "OpenSSL extension is not available"
**Solution:**
- Contact hosting support to enable OpenSSL
- Most shared hosting has it enabled by default

#### Issue: File Upload Size
**Error:** "File too large"
**Solution:** Already configured in `.htaccess`, but verify:
```apache
php_value upload_max_filesize 50M
php_value post_max_size 55M
```

### 7. Security Considerations

1. **HTTPS Recommended:**
   - Enable SSL/TLS certificate in cPanel
   - Uncomment HTTPS redirect in `.htaccess`

2. **Regular Cleanup:**
   - Files auto-delete after 30 minutes
   - Monitor `logs/cleanup.log` for cleanup status

3. **Access Control:**
   - Sensitive files protected by `.htaccess`
   - Config files not accessible via web

### 8. Maintenance

#### Log Files Location:
- Error logs: `logs/error.log`
- Cleanup logs: `logs/cleanup.log`

#### Manual Cleanup (if needed):
```bash
# Via cPanel File Manager, delete files older than 30 minutes in:
uploads/
temp/
downloads/
```

### 9. Domain-Specific Setup

The application auto-detects your domain and configures URLs automatically.
No manual domain configuration needed.

### 10. Troubleshooting

If issues persist:
1. Check `status.php` for system information
2. Review error logs in `logs/error.log`
3. Verify file permissions
4. Contact hosting support for PHP extension issues

### Support

For additional support:
- Check system status: `/status.php`
- Test OpenSSL: `/test_openssl.php`
- Review logs in `logs/` directory
